/*=======================================================*/
/*
 *  Listing 9.  devTrace.c 
 *
 *  trace program for generic user device
 *
 *  Placed in the Public Domain by Forest W. Arnold, 1994
*/
/*=======================================================*/

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/io.h>
#include <clib/exec_protos.h>
#include <clib/alib_protos.h>

#include <stdlib.h>
#include <stdio.h>

#include "devinit.h"

void main(int argc,char **argv )
{
   struct MsgPort *usrPort = NULL;
   struct IOStdReq *usrIO = NULL;
   struct Process  *self;
   BYTE   err;

   struct Library *usrDev;

   if ( argc < 2 )
   {
      printf("usage:  devTrace device_name\n");
      exit(1);
   }

   /*
    *  find task so we can send output file handle to
    *  the device for debugging
   */

   self = (struct Process*)FindTask(NULL);

   /*
    *  create port
   */

   usrPort = CreateMsgPort();
   if ( ! usrPort )
   {
      printf("Can't create message port\n");
      exit(1);
   }

   /*
    *  create io request
   */

   usrIO = CreateIORequest(usrPort,sizeof(struct IOStdReq));
   if ( ! usrIO )
   {
      printf("Can't create IO request\n");
      goto allDone;
   }

   printf("Calling OpenDevice for device %s\n",argv[1]);

   err = OpenDevice(argv[1],0,
                    (struct IORequest*)usrIO,0);
   if ( err )
   {
      printf("Can't open %s\n",argv[1]);
      goto allDone;
   }

   usrDev = (struct Library*)usrIO->io_Device;

   /*
    *  turn on debug trace output
   */

   printf("Calling DoIO with DEV_DBG_ON request\n");

   usrIO->io_Command = DEV_DBG_ON;
   usrIO->io_Data    = (APTR)self->pr_COS;

   err = DoIO((struct IORequest*)usrIO);
   if ( err )
      printf("DoIO failed\n");
   else
   {
      printf("Trace output enabled...\n");
      printf("'Ctrl-C' to disable and quit.\n");      
   }

   /*
    *  wait for control c
   */

   Wait( SIGBREAKF_CTRL_C );

   printf("Calling DoIO with DEV_DBG_OFF request\n");

   usrIO->io_Command = DEV_DBG_OFF;
   err = DoIO((struct IORequest*)usrIO);
   if ( err )
      printf("DoIO failed\n");

   /*
    *  close the device
   */
   
   printf("Calling CloseDevice\n");

   CloseDevice((struct IORequest*)usrIO);

allDone:

   if( usrIO )
      DeleteIORequest(usrIO);

   if( usrPort )
      DeleteMsgPort(usrPort);      

   exit(0);
}
